PACKAGE math IS    
FUNCTION "+"( l,r : BIT_VECTOR) RETURN INTEGER; 
END math;
 
PACKAGE BODY math IS    
  FUNCTION vector_to_int( S : BIT_VECTOR) RETURN INTEGER IS        
    VARIABLE result : INTEGER := 0; 
    VARIABLE prod : INTEGER := 1;   
  BEGIN        
    FOR i IN s'RANGE LOOP            
      IF s(i) = '1' THEN                 
        result := result + prod;            
      END IF;            
      prod := prod * 2;        
    END LOOP;
        
    RETURN result;    
  END vector_to_int;
    
  FUNCTION "+"(l,r : BIT_VECTOR) RETURN INTEGER IS    
  BEGIN        
    RETURN ( vector_to_int(l) + vector_to_int(r));    
  END; 
END math;

USE WORK.math.ALL; 
ENTITY adder IS    
  PORT( a, b : IN BIT_VECTOR(0 TO 7);          
        c : IN INTEGER;          
        dout : OUT INTEGER); 
END adder; 

ARCHITECTURE test OF adder IS    
  SIGNAL internal : INTEGER; 
BEGIN    
  internal <= a + b;    
  dout <= c + internal; 
END test;



